import { NChats } from '../components/ChatsCommon/types';
import MESSAGE_TYPE = NChats.MESSAGE_TYPE;

const TIME_CHARS_NUMBER = 1e13;

export class MessageItem {
    type: MESSAGE_TYPE = MESSAGE_TYPE.SENDING;
    text = '';
    author = '';
    id = 0;
    timestamp: number = new Date().getTime();
    chat_id = '';
    user_id = '';
    _type: MESSAGE_TYPE;

    constructor(props?: any) {
        if (props.chat_id) {
            this.chat_id = props.chat_id;
        }

        if (props.user_id) {
            this.user_id = props.user_id;
        }

        if (props.id) {
            this.id = props.id + new Date().getTime() / TIME_CHARS_NUMBER;
        }

        if (props._type) {
            this._type = props._type;
        }
    }

    setText(text) {
        this.text = text;

        return this;
    }
}

export class MessageResourceItem extends MessageItem {
    type: MESSAGE_TYPE = MESSAGE_TYPE.SENDING_RESOURCE;
    files: File[] = [];

    constructor(props) {
        super(props);
    }

    setFiles(files: File[]) {
        this.files = files;
    }
}

export class TopicMessageItemResource extends MessageItem {
    link: string;
    icon: string;
}
