import { EMPTY_DATA } from "../constants";

export class GeoJson {
    public static features: [{
        geometry: {
            coordinates: number[][];
            type: string;
        };
        id: number;
        properties: {
            description: any;
        };
        type: string;
    }];
    public static metadata: {
        creator: string;
        name: string;
    };
    public static type: string;
}

export class GeoJsonHandler extends GeoJson {
    public static getName(): string {
        return this
      && this.metadata
      && this.metadata.name || EMPTY_DATA;
    }

    public static getId(item = 0): any {
        return this
      && this.features
      && this.features[item]
      && this.features[item].id;
    }

    public static getFeatures() {
        return this && this.features || [];
    }

    public static getDescription(item = 0): string {
        const description = this?.features?.[item]?.properties?.description;

        return Array.isArray(description) ? description.join(";")
            : description || EMPTY_DATA;
    }

    public static getPlainCoordinates(item = 0): string {
        return this
      && this.features
      && this.features[item]
      && this.features[item].geometry
      && this.features[item].geometry.coordinates
      && this.features[item].geometry.coordinates.toString().replace(/\,/ig, " ") || "";
    }
}
