export class RoleItemSlave {
    link_meta: any;
    rol_id: string;
    slave_role_id: string;
}

export interface Restrictions{
    day: number;
    time_to: number;
    time_from: number;
}
export interface TimeRestriction {
    time_zone: number;
    restrictions: Restrictions[];
}

interface ActionMeta {
    time_restrictions: TimeRestriction;
}

export class ActionItemSlave {
    rol_id: string;
    role_action_meta: ActionMeta;
    action_id: string;
}

export class RoleItem {
    actions: ActionItemSlave[];
    role_description: string;
    role_group: string;
    role_groupping_tags: string;
    role_id: string;
    role_is_idm: string;
    role_is_public: string;
    role_optional: string;
    slave_roles: RoleItemSlave[];
}

class Confirmation {
    comment: string;
    history_instant: number;
    user_id: string;
}

export class RoleProposition extends RoleItem {
    proposition_id: string;
    proposition_description: string;
    proposition_author: string;
    confirmators: string[];
    confirmations_need: number;
    confirmations_count: number;
    confirmations: Confirmation[];
}
