import { TAG_ACTION } from '../../types';
import { EMPTY_DATA, ONE_SECOND } from '../constants';
import { MinimalUserInfo, UserInfoHandler } from './user';

export interface ITagDetails {
    amount_deadline: number;
    comment: string;
    priority: string;
    amount?: number;
    performer?: string;
    car_number?: string;
    links?: { type: string; uri: string }[];
    topic_link?: string;
}

export interface CategorizationItem {
    timestamp: number;
    operator_id: string;
    category: CategorizationCategory;
    comment: string;
    id: number;
}

export interface CategorizationCategoryMeta {
    origins: string[];
    enabled: boolean;
    label: string;
    order: number;
    call_direction: string;
    keywords: string[];
}

export interface CategorizationCategory {
    meta: CategorizationCategoryMeta;
    id: number;
}

export class TagRecord {
    public static action: TAG_ACTION;
    public static object_id: string;
    public static tag_details: ITagDetails;
    public static tag_display_name: string;
    public static tag_id: string;
    public static tag_name: string;
    public static timestamp: number;
    public static user_data_full: MinimalUserInfo;
    public static user_id: string;
    public static call_url: string;
    public static call_length: number;

    public static call: {
        connect: number;
        enter: number;
        exit: number;
        url: string;
    };

    public static categorization: {
        tag_id: string;
        items: CategorizationItem[];
    };
}

export class TagRecordHandler extends TagRecord {

    public static getCategorization(): CategorizationItem[] {
        return this?.categorization?.items || [];
    }

    public static getAction() {
        return this
            && this.action;
    }

    public static getTagName() {
        return this
            && this.tag_name;
    }

    public static getTagId() {
        return this
            && this.tag_id;
    }

    public static getTagDisplayName() {
        return this
            && this.tag_display_name;
    }

    public static getTagAuthor() {
        return this
            && this.user_data_full
            && (UserInfoHandler.getPrintNameWithoutPn.call(this.user_data_full)
                || this.user_id);
    }

    public static getTagUsername() {
        return this
            && this.user_data_full
            && (UserInfoHandler.getUsername.call(this.user_data_full)
                || EMPTY_DATA);
    }

    public static getTagAuthorLink() {
        return this
            && this.user_id
            && `${location.origin}/#/clients/${this.user_id}/info`;
    }

    public static getTagTimestamp() {
        return this
            && this.timestamp * ONE_SECOND;
    }

    public static getTagComment(): string {
        return this
            && this.tag_details
            && this.tag_details.comment
            || '';
    }

    public static getTagPriority() {
        return this
            && this.tag_details
            && this.tag_details.priority
            || 0;
    }

    public static getTagAmount() {
        return this
            && this.tag_details
            && this.tag_details.amount
            || 0;
    }

    public static getTagAmountDeadline() {
        return this?.tag_details?.amount_deadline
            ? this?.tag_details?.amount_deadline * ONE_SECOND
            : null;
    }

    public static getTagCarNumber() {
        return this
            && this.tag_details
            && this.tag_details.car_number
            || '';
    }

    public static getTagLinks(): string[] {
        return this
            && this.tag_details
            && this.tag_details.links
            && this.tag_details.links.reduce((acc: string[], item) => {
                acc.push(item.uri);

                return acc;
            }, [])
            || [];
    }
}
