import { createSelector } from 'reselect';

import { BASIC_MENU_TYPES } from '../../components/ChatsCommon/constants';
import { _CHATS, LinesMenuType } from '../../components/ChatsCommon/types';
import { FavouritesLines } from '../../components/FavouritesLines';

export const getChats = store => store.Chats || {};

export const getChatsSelector = createSelector(
    getChats,
    chats => chats || [],
);

export const getSelectedMenu = createSelector(
    getChatsSelector,
    chats => chats?.selectedMenu || '',
);

export const getSelectedMenuItem = createSelector(
    getChatsSelector,
    chats => chats?.selectedMenuItem || '',
);

export const getSelectedChatItem = createSelector(
    getChatsSelector,
    chats => chats?.selectedChatItem,
);

export const getIsFeedLoading = createSelector(
    getChatsSelector,
    chats => chats?.feedIsLoading,
);

export const areMyChatsLoading = createSelector(
    getChatsSelector,
    chats => chats?.my_chats_are_loading,
);

export const areAllChatsLoading = createSelector(
    getChatsSelector,
    chats => chats?.all_chats_are_loading,
);

export const areNewChatsLoading = createSelector(
    getChatsSelector,
    chats => chats?.new_chats_are_loading,
);

export const getAllUsersArray = createSelector(
    getChatsSelector,
    chats => chats?.[_CHATS.ALL]?.users || [],
);

export const getLinesListData = createSelector(
    getChatsSelector,
    chats => formatLinesListItems(chats) || [],
);

export const getFeedData = createSelector(
    [getChatsSelector, getSelectedMenu, getSelectedMenuItem],
    (chats, menu, submenu) => filterChats(chats, menu, submenu),
);

export const getMenuChats = createSelector(
    [getChatsSelector, getSelectedMenu],
    (chats, menu) => combineChats(chats[menu]?.chats) || [],
);

export const getMenuUsers = createSelector(
    [getChatsSelector, getSelectedMenu],
    (chats, menu) => getUsersObject(chats, menu) || {},
);

export const getMyChats = createSelector(
    getChatsSelector,
    chats => chats?.[_CHATS.MY] || [],
);

export const getStatusTags = createSelector(
    getMyChats,
    chats => chats?.status_tags || [],
);

export const getOriginatorInfo = createSelector(
    [getChatsSelector, getSelectedChatItem],
    (chats, currentChat) => getOriginator(chats, currentChat),
);

export const getSelectedChatDisplayName = createSelector(
    [getChatsSelector, getSelectedMenu, getSelectedChatItem],
    (chats, menu, currentChat) => getChatDisplayName(chats, menu, currentChat),
);

function formatLinesListItems(chats) {
    const linesListData: LinesMenuType = {} as LinesMenuType;
    const favLines = new FavouritesLines();

    BASIC_MENU_TYPES.forEach(menuName => {
        const menuData = chats[menuName];

        if (menuData) {
            const items: any = [];
            getData(menuData, items);

            items.sort((l1, l2) => {
                return favLines.match(menuName, l2.name)
                    ? 1 : favLines.match(menuName, l1.name)
                        ? -1 : l2.chats_count - l1.chats_count;
            });

            const totalItems = menuData.chats?.urgent?.length;
            linesListData[menuName] = {
                info: {
                    totalItems: totalItems ?? 0,
                },
                items,
            };
        }
    });

    return linesListData;
}

function getData(menuData, items) {
    const menus = menuData.chats?.urgent || [];

    menus.forEach(menu => {
        const currentTag = menuData.tags?.find(el => {
            return el.name === menu?.tag_data?.tag;
        }) || {};

        const linesTag = items.find(el => el.name === currentTag.name);

        if (linesTag) {
            linesTag.chats_count++;
        } else {
            const newItem = {
                name: currentTag.name,
                display_name: currentTag.display_name,
                chats_count: 0,
            };

            newItem.chats_count++;
            items.push(newItem);
        }
    });
}

function combineChats(chats) {
    return chats && chats.urgent || [];
}

function getUsersObject(chats, menu) {
    const data = chats[menu]?.users || [];
    const users: any = {};

    data.map(el => {
        if (!users.hasOwnProperty(el.id)) {
            users[el.id] = el;
        }
    });

    return users;
}

function filterChats(allInfo, menu, submenu) {
    const data = allInfo[menu]
        ? [
            ...allInfo[menu]?.chats?.urgent,
        ]
        : [];

    return submenu ? data.filter(el => el?.tag_data.tag === submenu) : data;
}

function getOriginator(chats, currentChat) {
    const menu = chats?.selectedMenu === _CHATS.CUSTOM ? _CHATS.CUSTOM : _CHATS.ALL;
    const users = chats[menu]?.users || [];

    return users.find(el => el.id === currentChat?.originator) || {};
}

function getChatDisplayName(chats, menu, currentChat) {
    const tags = chats[menu]?.tags || [];

    return tags.find(el => el.name === currentChat?.tag_data?.tag)?.display_name || '';
}
