import { getTagId } from '../../components/ChatsCommon/chatUtils';
import { _CHATS } from '../../components/ChatsCommon/types';

interface ISelectedMenuItem {
    name: string;
    display_name: string;
}

export interface IChatReducerState {
    selectedMenu: string;
    selectedMenuItem: ISelectedMenuItem | null;
    selectedChatItem: any;
    feedIsLoading: boolean;
    my_chats_are_loading: boolean;
    all_chats_are_loading: boolean;
    new_chats_are_loading: boolean;
}

export interface ChatAction {
    type: ChatReducerType;
    payload: any;
    error?: any;
}

export const initialState = {
    [_CHATS.ALL]: null,
    [_CHATS.MY]: null,
    [_CHATS.NEW]: null,
    [_CHATS.DEFFER]: null,
    [_CHATS.ARCHIVE]: null,
    [_CHATS.CUSTOM]: null,

    selectedMenu: '',
    selectedMenuItem: null,
    selectedChatItem: null,
    feedIsLoading: false,
    my_chats_are_loading: false,
    all_chats_are_loading: false,
    new_chats_are_loading: false,
};

export enum ChatReducerType {
    SET_CHATS = 'SET_CHATS',
    SET_CHATS_LOADING = 'SET_CHATS_LOADING',
    SET_SELECT_LIST = 'SET_SELECT_LIST',
    SELECT_CHAT_ITEM = 'SELECT_CHAT_ITEM',
    SET_FEED_IS_LOADING = 'SET_FEED_IS_LOADING',
    UPDATE_CHAT_ITEM_TAG = 'UPDATE_CHAT_ITEM_TAG',
    CANCEL_CHAT_CALLBACK = 'CANCEL_CHAT_CALLBACK',
}

export const chatReducer = (state: IChatReducerState = initialState, action: ChatAction) => {
    switch(action.type) {
    case ChatReducerType.SET_CHATS:
        return {
            ...state,
            [action.payload.type]: action.payload.response,
        };
    case ChatReducerType.SET_SELECT_LIST:
        return {
            ...state,
            selectedMenu: action.payload.type,
            selectedMenuItem: action.payload.menu,
            selectedChatItem: action.payload.chat ?? null,
        };
    case ChatReducerType.SELECT_CHAT_ITEM:
        return {
            ...state,
            selectedChatItem: action.payload,
        };
    case ChatReducerType.UPDATE_CHAT_ITEM_TAG:
        const isCustomChats = state.selectedMenu === _CHATS.CUSTOM;
        const chats = [
            ...state[isCustomChats ? _CHATS.CUSTOM : _CHATS.ALL]?.chats?.urgent,
        ] || [];

        const prevItem = chats.find(el => getTagId(el) === getTagId(action.payload.chat)) || {};
        const item = Object.assign({}, prevItem);
        item.tag_data = action.payload.tag;

        return {
            ...state,
            selectedChatItem: item,
        };
    case ChatReducerType.SET_FEED_IS_LOADING:
        return {
            ...state,
            feedIsLoading: action.payload,
        };
    case ChatReducerType.SET_CHATS_LOADING:
        return {
            ...state,
            [`${action.payload.chatType}_are_loading`]: action.payload.state,
        };
    case ChatReducerType.CANCEL_CHAT_CALLBACK: {
        return {
            ...state,
            selectedChatItem: null,
        };
    }

    default:
        return state;
    }
};
