import { _CHATS } from '../../components/ChatsCommon/types';
import { ChatAction, ChatReducerType } from './index';

export function setChats(payload: any, error: any): ChatAction {
    return {
        type: ChatReducerType.SET_CHATS,
        payload: payload,
        error,
    };
}

export function setSelectList(type: any, menu: any, chat?: any): ChatAction {
    return {
        type: ChatReducerType.SET_SELECT_LIST,
        payload: { type, menu, chat },
    };
}

export function selectChatItem(payload: any) {
    return {
        type: ChatReducerType.SELECT_CHAT_ITEM,
        payload,
    };
}

export function setFeedIsLoading(state: boolean) {
    return {
        type: ChatReducerType.SET_FEED_IS_LOADING,
        payload: state,
    };
}

export function cancelChatCallBack() {
    return {
        type: ChatReducerType.CANCEL_CHAT_CALLBACK,
    };
}

export function updateChatItemTag(chat, tag) {
    return {
        type: ChatReducerType.UPDATE_CHAT_ITEM_TAG,
        payload: { chat, tag },
    };
}

export function setChatsLoading(payload: { chatType: _CHATS; state: boolean }) {
    return {
        type: ChatReducerType.SET_CHATS_LOADING,
        payload,
    };
}
