import produce from 'immer';

import { Dict } from '../../types';

const initState: Dict<any> = {};

type ConstantsAction = SetConstants;

export enum ConstantsActionType {
    SET_CONSTANTS = 'SET_CONSTANTS',
}

interface SetConstants {
    type: ConstantsActionType.SET_CONSTANTS;
    payload: Dict<any>;
    error?: any;
}

export function setConstants(value: any, error: any): SetConstants {
    return {
        type: ConstantsActionType.SET_CONSTANTS,
        payload: value,
        error,
    };
}

export const constantsReducer = (state: Dict<any> = initState, action: ConstantsAction) =>
    produce(state, draft => {
        if (action.type === ConstantsActionType.SET_CONSTANTS && !action.error) {
            for (const key in action.payload) {
                draft[key] = action.payload[key];
            }
        }
    });
