import produce from 'immer';

import { LANGUAGES, LSSettingItems } from '../../types';
import LS from '../utils/localStorage/localStorage';
import { localizations } from './localizationInitData';
import { localizationsMock } from './tests/localizationData.mock';

export type LocalizationAction = InitLocalization | SetCurrentLang;

export enum LocalizationReducerType {
    INIT_LOCALIZATION = 'INIT_LOCALIZATION',
    SET_CURRENT_LANG = 'SET_CURRENT_LANG'
}

interface InitLocalization {
    type: LocalizationReducerType.INIT_LOCALIZATION;
    payload: ILocalizationItem[];
    error?: any;
}

interface SetCurrentLang {
    type: LocalizationReducerType.SET_CURRENT_LANG;
    payload: LANGUAGES;
    error?: any;
}

export function initLocalization(localization: ILocalizationItem[], error: any): InitLocalization {
    return {
        type: LocalizationReducerType.INIT_LOCALIZATION,
        payload: localization,
        error,
    };
}

export function setCurrentLang(lang: LANGUAGES, error: any): SetCurrentLang {
    return {
        type: LocalizationReducerType.SET_CURRENT_LANG,
        payload: lang,
        error,
    };
}

export interface ILocalizationItem {
    [key: string]: {
        [lang_key in LANGUAGES]: {
            value: string;
        }
    };
}

export interface LocalizationReducerState {
    currentLang: LANGUAGES;
    localizations: ILocalizationItem | null;
}

export const initState: LocalizationReducerState = {
    currentLang: new LS().get(LSSettingItems.lang),
    localizations: localizations,
};

export const initStateMock: LocalizationReducerState = {
    currentLang: LANGUAGES.ENG,
    localizations: localizationsMock,
};

export const localizationReducer = (state: LocalizationReducerState = initState, action: LocalizationAction) =>
    produce(state, draft => {
        switch (action.type) {
        /* case LocalizationReducerType.INIT_LOCALIZATION:
                let localizations = action.payload && action.payload.reduce((_p, _c: any) => {
                    if (!_c.resource_id.includes(LOCALIZATION_RESOURCE_PREFIX)) {
                        return _p;
                    }

                    let localizations = _c.localizations && _c.localizations.reduce((__p, __c) => {
                        return {
                            ...__p, ...{[__c.l]: {value: __c.v}}
                        };
                    }, {});
                    return {
                        ..._p,
                        [_c.resource_id]: localizations
                    };

                }, {}) || {};
                draft.localizations = localizations;
                break;*/
        case LocalizationReducerType.SET_CURRENT_LANG:
            draft.currentLang = action.payload;
            break;
        }
    });
