import React from 'react';

import Spin from '../../components/Spin';
import { ErrorSign } from '../ErrorBar';
import { UIComponent } from '../index';
import style from './index.css';

interface IActionCheckboxProps extends UIComponent {
    value: boolean;
    setValue: (value: boolean) => void;
    requestOnToggle: () => Promise<unknown>;
    expandError: (error: Error) => void;
    checkboxClassname?: string;
}

export const ActionCheckbox = (props: IActionCheckboxProps) => {
    const { value, requestOnToggle, required, checkboxClassname, className, disabled, setValue, expandError } = props;
    const [error, setError] = React.useState<Error | null>(null);
    const [isLoading, setLoading] = React.useState<boolean>(false);

    const onChange = async () => {
        setError(null);
        setLoading(true);

        try {
            await requestOnToggle();
            setValue(!value);
            setLoading(false);
        } catch (e) {
            setError(e);
            setLoading(false);
        }
    };

    return <span className={`${style.checkboxContainer} ${className ?? ''}`}>
        <input type="checkbox"
               checked={value}
               disabled={disabled}
               className={`${style.checkbox} ${checkboxClassname ?? ''} ${required ? style.required : ''}`}
               onChange={onChange.bind(null)}/>
        {isLoading && <Spin size={'s'}/>}
        {error && <ErrorSign onClick={expandError.bind(null, error)}/>}
    </span>;
};
