import React from 'react';

import style from './index.css';

export enum ArrowPosition {
    TOP = 'top',
    BOTTOM = 'bottom'
}

interface IArrowProps {
    onClick?: any;
    className?: string;
    position?: ArrowPosition;
}

export const Arrow = React.memo((props: IArrowProps) => {
    return <div className={`${style.arrow} ${props.className || ''} ${style[props.position || ArrowPosition.BOTTOM]}`}
                onClick={props.onClick && props.onClick.bind(null) || null}/>;
});
