import * as React from 'react';

import { Dict } from '../../../../types';
import { Button, ButtonTypes } from '../index';
import * as style from './index.css';

export interface IRadioButtonItem {
    item: string;
    value: string;
    disabled?: boolean;
}

export interface IRadioButtonGroup {
    items: IRadioButtonItem[];
    active: string;
    disabled?: boolean;
    style?: Dict<any> ;
    type?: ButtonTypes[];
    onChange: (value: string) => void;
}

export class RadioButtonGroup extends React.Component <IRadioButtonGroup, any> {
    public static defaultProps: Partial<IRadioButtonGroup> = {
        style: {},
        type: [ButtonTypes.positive, ButtonTypes.negative],
    };

    state = {
        currentItem: this.props.active,
    };

    componentDidUpdate(prevProps: Readonly<IRadioButtonGroup>): void {
        if (this.props.active !== prevProps.active) {
            this.setState({ currentItem: this.props.active });
        }
    }

    onClick(value: string) {
        this.setState({ currentItem: value }, () => {
            this.props.onChange(value);
        });

    }

    public render() {

        return (
            <div className={style.radio_button_group}>
                {

                    this.props.items.map(button => {
                        const isSelected = this.state.currentItem === button.value;

                        return <Button key={button.item}
                                       onClick={this.onClick.bind(this, button.value)}
                                       disabled={button.disabled}
                                       className={style.radio_button}
                                       basic={!isSelected}>{button.item}</Button>;
                    })
                }
            </div>
        );
    }
}
