import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import React from 'react';

import { Button, ButtonTypes } from './index';
import style from './index.story.css';

require('../../components/App/index.css');

storiesOf('Button', module)
    .add('All', () => (
        <div className={style.button__margins}>
            <h3>Primary: </h3>
            <Button onClick={action('clicked')}>Кнопка</Button>
            <Button isLoading={true} onClick={action('clicked')}>Кнопка</Button>
            <Button basic={true} onClick={action('clicked')}>Кнопка</Button>
            <Button basic={true} isLoading={true} onClick={action('clicked')}>Кнопка</Button>
            <h3>Positive: </h3>
            <Button colorType={ButtonTypes.positive} onClick={action('clicked')}>Кнопка</Button>
            <Button colorType={ButtonTypes.positive} isLoading={true} onClick={action('clicked')}>Кнопка</Button>
            <Button colorType={ButtonTypes.positive} basic={true} onClick={action('clicked')}>Кнопка</Button>
            <Button colorType={ButtonTypes.positive}
                    basic={true}
                    isLoading={true}
                    onClick={action('clicked')}>Кнопка</Button>
            <h3>Negative: </h3>
            <Button colorType={ButtonTypes.negative} onClick={action('clicked')}>Кнопка</Button>
            <Button colorType={ButtonTypes.negative} isLoading={true} onClick={action('clicked')}>Кнопка</Button>
            <Button colorType={ButtonTypes.negative} basic={true} onClick={action('clicked')}>Кнопка</Button>
            <Button colorType={ButtonTypes.negative}
                    basic={true}
                    isLoading={true}
                    onClick={action('clicked')}>Кнопка</Button>
            <h3>Disabled: </h3>
            <Button disabled={true} onClick={action('clicked')}>Кнопка</Button>
            <Button disabled={true} isLoading={true} onClick={action('clicked')}>Кнопка</Button>
        </div>
    ));

storiesOf('Button/Primary', module)
    .add('Primary', () => (
        <Button onClick={action('clicked')}>Кнопка</Button>
    ))
    .add('Primary loading', () => (
        <Button isLoading={true} onClick={action('clicked')}>Кнопка</Button>
    ))
    .add('Primary Basic', () => (
        <Button basic={true} onClick={action('clicked')}>Кнопка</Button>
    ))
    .add('Primary Basic loading', () => (
        <Button basic={true} isLoading={true} onClick={action('clicked')}>Кнопка</Button>
    ));

storiesOf('Button/Positive', module)
    .add('Positive', () => (
        <Button colorType={ButtonTypes.positive} onClick={action('clicked')}>Кнопка</Button>
    ))
    .add('Positive loading', () => (
        <Button colorType={ButtonTypes.positive} isLoading={true} onClick={action('clicked')}>Кнопка</Button>
    ))
    .add('Positive Basic', () => (
        <Button colorType={ButtonTypes.positive} basic={true} onClick={action('clicked')}>Кнопка</Button>
    ))
    .add('Positive Basic loading', () => (
        <Button colorType={ButtonTypes.positive}
                basic={true}
                isLoading={true}
                onClick={action('clicked')}>
            Кнопка
        </Button>
    ));

storiesOf('Button/Negative', module)
    .add('Negative', () => (
        <Button colorType={ButtonTypes.negative} onClick={action('clicked')}>Кнопка</Button>
    ))
    .add('Negative loading', () => (
        <Button colorType={ButtonTypes.negative} isLoading={true} onClick={action('clicked')}>Кнопка</Button>
    ))
    .add('Negative Basic', () => (
        <Button colorType={ButtonTypes.negative} basic={true} onClick={action('clicked')}>Кнопка</Button>
    ))
    .add('Negative Basic loading', () => (
        <Button colorType={ButtonTypes.negative}
                basic={true}
                isLoading={true}
                onClick={action('clicked')}>
            Кнопка
        </Button>
    ));

storiesOf('Button/Disabled', module)
    .add('Disabled', () => (
        <Button disabled={true} onClick={action('clicked')}>Кнопка</Button>
    ))
    .add('Disabled loading', () => (
        <Button disabled={true} isLoading={true} onClick={action('clicked')}>Кнопка</Button>
    ));
