import * as React from 'react';

import { ButtonTypes } from '../../Button';
import RadioGroup from '../../Radio/RadioGroup';
import { IRadioGroupOptions } from '../../Radio/RadioGroup/component';
import ButtonWithPopup from '../index';
import styles from './index.css';

interface IButtonWithChoicesPopupProps {
    id: string;
    options: IRadioGroupOptions[];
    initialSelectedValue?: string;
    onSelect: (value: string) => void;
    colorType?: ButtonTypes;
    markIfNonDefaultChoice?: boolean;
    displayArrowIcon?: boolean;
    disabled?: boolean;
}

export const ButtonWithChoicesPopup = (props: React.PropsWithChildren<IButtonWithChoicesPopupProps>) => {
    const {
        markIfNonDefaultChoice,
        options,
        onSelect,
        disabled,
        children,
        id,
        displayArrowIcon,
        colorType,
        initialSelectedValue,
    } = props;
    const [isDefaultValue, setDefaultValue] = React.useState<string | null>(null);
    const [selectedValue, setSelectedValue] = React.useState<string | null>(initialSelectedValue ?? null);

    const popupContent = <RadioGroup colorType={colorType}
                                     initialSelectedValue={selectedValue}
                                     options={options}
                                     id={id}
                                     onSelect={(value) => {
                                         setSelectedValue(value);
                                         onSelect(value);
                                     }}
                                     className={styles.options}/>;

    React.useEffect(() => {
        if (initialSelectedValue) {
            setSelectedValue(initialSelectedValue);
        }
    }, [initialSelectedValue]);

    React.useEffect(() => {
        options.forEach((option) => {
            if (option.isDefault) {
                setDefaultValue(option.value);
                setSelectedValue(option.value);
            }
        });
    }, []);

    return <ButtonWithPopup disabled={disabled}
                            colorType={colorType}
                            className={markIfNonDefaultChoice && isDefaultValue !== selectedValue
                                ? styles.markIfNonDefaultChoice
                                : ''
                            }
                            popupContent={popupContent}
                            displayArrowIcon={displayArrowIcon}>
        {children}
    </ButtonWithPopup>;
};
