import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { ButtonWithChoicesPopup } from './component';
import styles from './index.story.css';

storiesOf('ButtonWithChoicesPopup', module)
    .add('initial', () => {
        return <ButtonWithChoicesPopup id={'test-choices'}
                                       onSelect={() => undefined}
                                       options={[
                                           { label: 'test', value: '1', isDefault: true },
                                           { label: 'test2', value: '2' },
                                       ]}>
            Test TEST Test test
        </ButtonWithChoicesPopup>;
    })
    .add('markIfNonDefaultChoice', () => {
        return <ButtonWithChoicesPopup id={'test-choices'}
                                       markIfNonDefaultChoice
                                       onSelect={() => undefined}
                                       options={[
                                           { label: 'test', value: '1', isDefault: true },
                                           { label: 'test2', value: '2' },
                                       ]}>
            Test
        </ButtonWithChoicesPopup>;
    })
    .add('markIfNonDefaultChoice + displayArrowIcon', () => {
        return <>
            <ButtonWithChoicesPopup id={'test-choices'}
                                    markIfNonDefaultChoice
                                    displayArrowIcon
                                    onSelect={() => undefined}
                                    options={[
                                        { label: 'test', value: '1', isDefault: true },
                                        { label: 'test2', value: '2' },
                                    ]}/>
            <div className={styles.container}>
                <ButtonWithChoicesPopup id={'test-choices'}
                                        markIfNonDefaultChoice
                                        displayArrowIcon
                                        onSelect={() => undefined}
                                        options={[
                                            { label: 'test', value: '1', isDefault: true },
                                            { label: 'test2', value: '2' },
                                        ]}/>
            </div>
        </>;
    });
