import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { ButtonTypes } from '../Button';
import ButtonWithPopup from './index';
import styles from './index.story.css';

storiesOf('ButtonWithPopup', module)
    .add('initial', () => {
        return <ButtonWithPopup colorType={ButtonTypes.negative}
                                popupContent={<span>test</span>}>
            Test
        </ButtonWithPopup>;
    })
    .add('all colors and directions', () => {
        return <>
            <div className={styles.containerTop}>
                <div>
                    <ButtonWithPopup colorType={ButtonTypes.negative}
                                     popupContent={<span>test</span>}>
                        Test
                    </ButtonWithPopup>
                </div>
                <div>
                    <ButtonWithPopup colorType={ButtonTypes.positive}
                                     popupContent={<span>test</span>}>
                        reest
                    </ButtonWithPopup>
                </div>
            </div>
            <div className={styles.containerDown}>
                <div>
                    <ButtonWithPopup popupContent={<span>test</span>}>
                        Test TEST test Test
                    </ButtonWithPopup>
                </div>
                <div>
                    <ButtonWithPopup colorType={ButtonTypes.warning}
                                     popupContent={<span>
                            Test Test TEST test Test Test TEST test Test Test TEST
                            Test Test TEST test Test Test TEST test Test Test TEST
                            Test Test TEST test Test Test TEST test Test Test TEST
                            Test Test TEST test Test Test TEST test Test Test TEST
                            Test Test TEST test Test Test TEST test Test Test TEST
                            Test Test TEST test Test Test TEST test Test Test TEST
                                     </span>}>
                        Test Test TEST test Test Test TEST test Test Test TEST
                    </ButtonWithPopup>
                </div>
            </div>
        </>;
    });
