import * as React from 'react';

import Spin from '../../components/Spin';
import { Button, ButtonTypes } from '../Button';
import { ErrorsModal } from '../ErrorBar';
import FormatDate from '../FormatDate';
import { Link } from '../Link';

interface ICacheControl {
    hasCache: boolean;
    newCacheAvailable: boolean;
    cacheTimestamp: number;
    className?: string;
    classNameLoading?: string;
    error: Error | null;
    reloadData: () => void;
}

export const CacheControl = (props: ICacheControl) => {
    const {
        hasCache,
        cacheTimestamp,
        newCacheAvailable,
        className = '',
        classNameLoading = '',
        error,
        reloadData,
    } = props;
    const [isErrorModalShowing, showErrorModal] = React.useState(false);

    return (
        <>
            {newCacheAvailable
                ? <div className={className}>
                    <span>
                            Данные от <FormatDate value={cacheTimestamp}/>
                    </span>
                    <Button colorType={ButtonTypes.warning}
                            onClick={reloadData.bind(null)}>Обновить данные</Button>
                </div>
                : !hasCache && !newCacheAvailable
                    ? <span className={className}>
                        Данные от <FormatDate value={cacheTimestamp}/>
                    </span>
                    : error
                        ? <div className={className}>
                            <p>Произошла ошибка :(</p>
                            <p>
                                <Link onClick={showErrorModal.bind(null, true)}>
                                    Подробнее
                                </Link>
                            </p>
                            {cacheTimestamp
                                ? <p>Данные от <FormatDate value={cacheTimestamp}/></p>
                                : null
                            }
                            <Button colorType={ButtonTypes.positive}
                                    onClick={reloadData.bind(null)}>
                                Перезапросить данные
                            </Button>
                        </div>
                        : <div className={className}>
                            {cacheTimestamp
                                ? <p>Данные от <FormatDate value={cacheTimestamp}/></p>
                                : null
                            }
                            <span className={classNameLoading}>
                                Идет обновление <Spin size={'s'}/>
                            </span>
                        </div>
            }
            {isErrorModalShowing && (
                <ErrorsModal errors={[error]}
                             onClose={showErrorModal.bind(null, false)}/>
            )}
        </>
    );
};
