import React, { ReactElement } from 'react';

import * as style from './index.css';

export interface ICardProps {
    title?: string | ReactElement;
}

export class Card extends React.Component<ICardProps, any> {

    render() {
        return <div className={style.card}>
            {this.props.title
                ? <div className={style.card_title}>{this.props.title}</div>
                : null}
            <div className={style.card_content}>
                {this.props.children}
            </div>
        </div>;
    }
}
