import React from 'react';
import ReactTooltip from 'react-tooltip';

import { UIComponent } from '../index';
import style from './index.css';

interface IProps extends UIComponent {
    checked: boolean | '1' | '0';
    onChange?: (value: any) => any;
    plain?: boolean;
}

interface IState {
    checked: boolean;
    disabled?: boolean;
}

class Checkbox extends React.Component<IProps, IState> {
    id = Math.random();
    state = {
        checked: this.props.checked === '1' || this.props.checked === true,
        disabled: this.props.disabled,
    };

    shouldComponentUpdate(nextProps: Readonly<IProps>, nextState: Readonly<IProps>, nextContext: any): boolean {
        return (this.state.checked !== nextState.checked ||
            this.state.disabled !== nextState.disabled);
    }

    UNSAFE_componentWillReceiveProps(nextProps: Readonly<IProps>, nextContext: any): void {
        if (this.props.checked !== nextProps.checked || this.props.disabled !== nextProps.disabled) {
            this.setState({
                checked: nextProps.checked === '1' || nextProps.checked === true,
                disabled: nextProps.disabled,
            });
        }
    }

    onChange() {
        this.setState({ checked: !this.state.checked }, () => {
            this.props.onChange && this.props.onChange(this.state.checked);
        });
    }

    render() {
        const { description, plain } = this.props;
        const id = `description_checkbox_${this.id}`;
        const defaultClassname = `${style.checkbox} ${this.props.className || ''} ${this.props.required
            ? style.required
            : ''}`;

        return <div className={style.checkbox_container}>
            {description
                ? <div>
                    <div data-tip data-for={id} className={style.description_icon}>?</div>
                    <ReactTooltip className={style.description_tooltip}
                                  place={'left'}
                                  id={id}
                                  effect="solid">
                        {description}
                    </ReactTooltip>
                </div>
                : null}<input type="checkbox"
                              checked={this.state.checked}
                              disabled={this.state.disabled}
                              className={!plain ? defaultClassname : ''}
                              onChange={this.onChange.bind(this)}/>
        </div>;
    }
}

export default Checkbox;

export class CheckboxExternal extends React.Component<IProps, IState> {

    state = {
        checked: this.props.checked === '1' || this.props.checked === true,
        disabled: this.props.disabled,
    };

    shouldComponentUpdate(nextProps: Readonly<IProps>, nextState: Readonly<IProps>, nextContext: any): boolean {
        return (this.state.checked !== nextState.checked ||
            this.state.disabled !== nextState.disabled);
    }

    UNSAFE_componentWillReceiveProps(nextProps: Readonly<IProps>, nextContext: any): void {
        if (this.props.checked !== nextProps.checked || this.props.disabled !== nextProps.disabled) {
            this.setState({
                checked: nextProps.checked === '1' || nextProps.checked === true,
                disabled: nextProps.disabled,
            });
        }
    }

    onChange() {
        this.props.onChange && this.props.onChange(this.state.checked);
    }

    render() {
        return <input type="checkbox"
                      checked={this.state.checked}
                      disabled={this.state.disabled}
                      className={`${style.checkbox} ${this.props.className || ''} ${this.props.required
                          ? style.required
                          : ''}`}
                      onChange={this.onChange.bind(this)}/>;
    }
}
