import { storiesOf } from '@storybook/react';
import React, { useState } from 'react';

import { Collapse } from './index';

require('../../components/App/index.css');

const Component = () => {
    const [state, setState] = useState({ collapsed: true, count: 0 });

    return <Collapse collapsed={state.collapsed}
                     title={[
                         <span key="1">Коллапсер с кастомным обработчиком: </span>,
                         <strong key="2">{state.count}</strong>,
                     ]}
                     onClick={() => {
                         setState({ collapsed: !state.collapsed, count: state.count + 1 });
                     }}>
        <div>text</div>
    </Collapse>;
};

storiesOf('Collapse', module)
    .add('default', () => (
        <>
            <Collapse title={'Заголовок'}>
                <div>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Ad adipisci alias aperiam, consectetur
                    dolorum facilis inventore ipsum iste laboriosam maiores mollitia nisi nobis perferendis, repellendus
                    voluptas. Eveniet id perferendis sequi.
                </div>
            </Collapse>
            <Component/>
        </>
    ));
