import React from 'react';

import style from './index.css';

interface IProps {
    collapsed: boolean;
    title: any;
    onClick?: () => void;
    className?: string;
    force?: boolean;
}

export class Collapse extends React.Component<IProps, any> {
    state = {
        collapsed: true,
    };

    public static defaultProps: Partial<IProps> = {
        collapsed: false,
        title: 'unknown title',
    };

    toggle() {
        !this.props.onClick
            ? this.setState({
                collapsed: !this.state.collapsed,
            })
            : this.props.onClick();
    }

    componentDidMount() {
        this.setState({
            collapsed: this.props.collapsed,
        });
    }

    UNSAFE_componentWillReceiveProps(newProps: any) {
        if (newProps.collapsed !== this.props.collapsed) {
            this.setState({
                collapsed: newProps.collapsed,
            });
        }
    }

    childrenClick(e: KeyboardEvent) {
        e.stopPropagation();
    }

    render() {
        return <div className={style.collapse + (this.state.collapsed ? ` ${style.collapsed} ` : '') +
            (this.props.className ? ` ${this.props.className}` : '')}
                    onClick={this.toggle.bind(this)}>
            <div className={style['collapse-title']}>{this.props.title}</div>
            <div className={style['collapse-child']} onClick={this.childrenClick.bind(this)}>
                {(!this.state.collapsed || this.props.force) && this.props.children}
            </div>
        </div>;
    }
}
