import * as React from 'react';

import styles from './index.css';

interface ICollapse2Props {
    initialExpanded?: boolean;
    expandText?: string;
    closeText?: string;
    title: string;
    children: React.ReactNode;
    className?: string;
    headerClassname?: string;
    expendByRoot?: boolean;
}

export const Collapse2 = (props: ICollapse2Props) => {
    const {
        children,
        initialExpanded = false,
        expandText = 'Развернуть',
        closeText = 'Свернуть',
        title,
        className,
        headerClassname,
        expendByRoot,
    } = props;
    const [isExpanded, setExpanded] = React.useState(initialExpanded);

    const _setExpanded = (value, e) => {
        e?.stopPropagation();
        setExpanded(value);
    };

    return <>
        <div className={`${styles.header} ${headerClassname ?? ''} ${expendByRoot ? styles.interactive : ''}`}
             onClick={expendByRoot && _setExpanded.bind(null, !isExpanded) || null}>
            <h4>{title}</h4>
            <div className={`${styles.expandToggle} ${styles.interactive}`}
                 onClick={_setExpanded.bind(null, !isExpanded)}>
                {!isExpanded ? expandText : closeText}
            </div>
        </div>
        <div className={className ? className : ''}>
            {isExpanded
                ? children
                : null
            }
        </div>
        <hr className={styles.separator}/>
    </>;
};
