import * as React from 'react';
import XLSX from 'xlsx';

import SessionsHistoryItem, { SessionHistoryInfoHandler } from '../../models/session';
import { Button } from '../Button';
import { FormatDateInString } from '../FormatDate';

interface IDownloadSessionsButtonProps {
    sessionHistory: SessionsHistoryItem;
    spreadsheetTitle?: string;
    className?: string;
}

const downloadSessionsXLSX = (sessionHistory: SessionsHistoryItem, spreadsheetTitle: string) => {
    const sessionsCount = SessionHistoryInfoHandler.getCount.call(sessionHistory);

    const wb = XLSX.utils.book_new();
    const ws_data: string[][] = [];
    ws_data.push(
        [
            'Name',
            'Start',
            'Finish',
            'Duration',
            'City',
            'Car model',
            'Car number',
            'Offer name',
            'Total price',
            'Paid with',
        ],
    );

    for (let i = 0; i < sessionsCount; i++) {
        const row: string[] = [];
        row.push(SessionHistoryInfoHandler.getUserPrintName.call(sessionHistory, i));
        row.push(FormatDateInString({ value: SessionHistoryInfoHandler.getStart.call(sessionHistory, i) }));
        row.push(FormatDateInString({ value: SessionHistoryInfoHandler.getFinish.call(sessionHistory, i) }));
        row.push(SessionHistoryInfoHandler.getDuration.call(sessionHistory, i));
        row.push(SessionHistoryInfoHandler.getCity.call(sessionHistory, i));
        row.push(SessionHistoryInfoHandler.getModelName.call(sessionHistory, i));
        row.push(SessionHistoryInfoHandler.getCarNumber.call(sessionHistory, i));
        row.push(SessionHistoryInfoHandler.getOfferName.call(sessionHistory, i));
        row.push(SessionHistoryInfoHandler.getTotalPrice.call(sessionHistory, i));
        row.push(SessionHistoryInfoHandler.getSelectedCharge.call(sessionHistory, i));

        ws_data.push(row);
    }

    const ws = XLSX.utils.aoa_to_sheet(ws_data);
    XLSX.utils.book_append_sheet(wb, ws, 'Поездки');

    XLSX.writeFile(wb, `${spreadsheetTitle ?? 'sessionData'}.xlsx`);
};

export const DownloadSessionsButton = (props: IDownloadSessionsButtonProps) => {
    const { sessionHistory, spreadsheetTitle, className } = props;

    return <Button className={className}
                   onClick={downloadSessionsXLSX.bind(null, sessionHistory, spreadsheetTitle)}>
        Скачать данные о поездках
    </Button>;
};
