import React, { useState } from 'react';

import { SimpleError } from '../../components/SimpleError';
import { Window } from '../FullModal';
import * as style from './index.css';

export const ShortError = React.memo((props: { error: Error | null }) => {
    const [errorModalOpen, openErrorModal] = useState(false);

    return <>
        <div className={style.error_bar} onClick={openErrorModal.bind(null, true)}>
            <span>☠️ 🔥 Ошибка 🔥 ☠️</span>
        </div>
        {errorModalOpen
            ? <ErrorsModal onClose={openErrorModal.bind(null, false)} errors={[props.error]}/>
            : null
        }
    </>;
});
export const ErrorsModal = React.memo((props: { errors: Array<Error | null>; onClose: () => void; title?: string }) => {
    const { errors, title, onClose } = props;

    return <Window onClose={onClose} title={title ?? 'Ошибка'}>
        {errors?.length && errors?.[0] && errors?.map((error, index) => {
            return <SimpleError key={`error-modal-${index}`} error={error}/>;
        })}
    </Window>;
});

export const ErrorSign = React.memo((props: { onClick: () => Function }) => {
    return <span className={style.error_sign} onClick={props.onClick}/>;
});
