import { combineRequests, IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export const REQUESTS: { [key: string]: string } = combineRequests({
    ADD_MDS_RESOURCES: 'ADD_MDS_RESOURCES',
    GET_MDS_RESOURCES: 'GET_MDS_RESOURCES',
    ADD_ST_RESOURCES: 'ADD_ST_RESOURCES',
});

const BUCKET = 'carsharing';

export const MDS_REQUESTS: IComponentRequest = combineRequests({
    [REQUESTS.ADD_MDS_RESOURCES]: {
        method: REQUEST_METHOD.POST,
        api: `mds/add`,
        cgiObj: {
            key: null,
            bucket: BUCKET,
        },
    },
    [REQUESTS.GET_MDS_RESOURCES]: {
        api: 'mds/info',
        cgiObj: {
            bucket: BUCKET,
        },
    },
    [REQUESTS.ADD_ST_RESOURCES]: {
        method: REQUEST_METHOD.POST,
        api: `incident/upload_startrek_attachment`,
        cgiObj: {
            file_name: null,
        },
    },
});
