import { storiesOf } from '@storybook/react';
import React from 'react';

import { ONE_HOUR_IN_MINUTES, ONE_SECOND } from '../../constants';
import FormateDate, {
    dateLag,
    durationBetween,
    FormatDateInString,
    getAge,
    isEqualDate,
    reverseDate,
    stringToScheduleTime,
    timeDurationNow,
} from './index';

const TEN_SECONDS = 10000;

storiesOf('FormatDate', module)
    .add('default', () => <FormateDate value={new Date()}/>)
    .add('FormatDateInString', () => <>{FormatDateInString({ value: '11:11:2011' })}</>)
    .add('dateLag', () => <>{dateLag(Date.now(), Date.now() + ONE_HOUR_IN_MINUTES)}</>)
    .add('reverseDate', () => <>{reverseDate('24.12.2012')}</>)
    .add('isEqualDate', () => <>{isEqualDate([Date.now() / ONE_SECOND, Date.now()]).toString()}</>)
    .add('timeDurationNow', () => <>{timeDurationNow(Date.now() / ONE_SECOND - TEN_SECONDS)}</>)
    .add('durationBetween', () => <>{durationBetween([
        Date.now() / ONE_SECOND + ONE_SECOND,
        Date.now() / ONE_SECOND - TEN_SECONDS,
    ])}</>)
    .add('getAge', () => <>{getAge('1996-11-19', new Date('2019-07-05'))}</>)
    .add('stringToScheduleTime', () => <>{stringToScheduleTime('1200')}</> );
