import * as React from 'react';

import { Copy } from '../../components/Copy';
import Spin from '../../components/Spin';
import { Button, ButtonTypes } from '../Button';
import * as coreStyle from '../index.css';
import { Window } from './index';
import style from './index.css';
import { IModal } from './types';
import { ViewerJSON } from './ViewerJSON';

interface IJsonModal extends IModal {
    obj: any;
    error?: Error | null;
    isLoading?: boolean;
}

enum TabsTitle {
    TEXT = 'text',
    JSON = 'json'
}

export class JsonModal extends React.Component<IJsonModal> {
    state = {
        selectTab: TabsTitle.TEXT,
        tabs: [
            { name: TabsTitle.TEXT.toUpperCase(), link: TabsTitle.TEXT },
            { name: TabsTitle.JSON.toUpperCase(), link: TabsTitle.JSON },
        ],
    };

    selectTab(selectTab) {
        this.setState({
            selectTab,
        });
    }

    render() {
        const JSONControls = (props: { onClose: () => {}; obj: any }) => {
            return <div className={`${coreStyle.button_container} ${coreStyle.full_width}`}>
                <div>
                    <Button colorType={ButtonTypes.negative}
                            onClick={props.onClose}>Закрыть</Button>
                    <Copy text={JSON.stringify(props.obj)}>
                        <Button colorType={ButtonTypes.positive}>Копировать</Button>
                    </Copy>
                </div>
            </div>;
        };

        return <Window title={this.props.title}
                       className={`${style.json} ${this.props.className}`}
                       error={this.props.error ? this.props.error : ''}
                       onClose={this.props.onClose.bind(this) || undefined}>
            <div className={style.jsonContent}>
                <div>
                    {this.props.children}
                </div>
                {
                    this.props.isLoading ? <Spin size={'s'}/> : null
                }
                <ViewerJSON onClose={this.props.onClose.bind(this) || undefined} JSONData={this.props.obj}/>
            </div>
            <JSONControls onClose={this.props.onClose.bind(this)} obj={this.props.obj}/>
        </Window>;
    }
}
