import * as React from 'react';
import ReactJson from 'react-json-view';

import { Dict } from '../../../../types';
import { FormConstructor } from '../../../components/FormConstructor';
import { controlType, ISchemaItem } from '../../../components/FormConstructor/types';
import { isObjectEqual } from '../../../utils/isObjectEqual';
import { Tabs } from '../../Tabs';

interface IViewerJSON {
    onClose?: () => void;
    onChange?: (e: any) => void;
    JSONData: Dict<any>;
    schema?: Dict<any>;
}

enum TabsTitle {
    TEXT = 'text',
    JSON = 'json',
}

export class ViewerJSON extends React.Component<IViewerJSON> {
    state = {
        selectTab: TabsTitle.TEXT,
        tabs: [
            { name: TabsTitle.TEXT.toUpperCase(), link: TabsTitle.TEXT },
            { name: TabsTitle.JSON.toUpperCase(), link: TabsTitle.JSON },
        ],
        JSONDataInit: this.props.JSONData,
        JSONData: this.props.JSONData,
    };

    componentDidUpdate(prevProps): void {
        if (!isObjectEqual(this.props.JSONData, prevProps.JSONData)) {
            this.setState({ JSONDataInit: this.props.JSONData, JSONData: this.props.JSONData });
        }
    }

    schema: Dict<ISchemaItem> = {
        textarea: {
            type: controlType.json,
            required: true,
        },
    };

    selectTab(selectTab) {
        this.setState({
            selectTab,
        });
    }

    onJSONChange(data) {
        if (data && data.textarea) {
            this.setState({
                JSONData: data.textarea,
            }, () => {
                this.props.onChange && this.props.onChange(this.state.JSONData);
            });
        }
    }

    render() {
        const JSON_SPACE = 2;

        return (
            <div>
                <Tabs selectTab={this.selectTab.bind(this)}
                      tabs={this.state.tabs}
                      currentTab={this.state.selectTab}/>

                <div>
                    {this.state.selectTab === TabsTitle.JSON
                        ? <ReactJson src={this.state.JSONData}
                                     displayObjectSize={false}
                                     displayDataTypes={false}
                                     enableClipboard={false}
                                     collapsed={4}/>
                        : <div>
                            {this.props.onChange ? (
                                <FormConstructor schema={this.schema}
                                                 onChange={this.onJSONChange.bind(this)}
                                                 initialData={{ textarea: this.state.JSONDataInit.textarea }}/>
                            ) : (
                                <pre> {JSON.stringify(this.state.JSONData, null, JSON_SPACE)} </pre>
                            )}
                        </div>
                    }
                </div>
            </div>
        );
    }
}
