import * as React from 'react';
import ReactTooltip from 'react-tooltip';

import * as style from './index.css';

export const GroupingTag = React.memo((props: { data: string; id: string }) => {
    const { data, id } = props;
    const array = data && data.split(',') || [];
    const count = array.length;
    const isMulti = count > 1;
    const text = data && data.split(',').length;
    const tooltip = array.map((el: string, i: number) => {
        return <div key={i}>{el}</div>;
    });

    return count ?
        <BallItem text={text}
                  id={id}
                  tooltip={tooltip}
                  type={'info'}
                  place={'right'}
                  className={isMulti ? style.multi : ''}/>
        : null;
});

interface IBallProps {
    text: any;
    id: string;
    type?: any;
    place?: any;
    tooltip: any;
    className?: string;
    onlyBall?: boolean;
}

export const BallItem = React.memo((props: IBallProps) => {
    const { text, id, type = 'info', place = 'top', tooltip = '', className = '', onlyBall = false } = props;

    return <div className={`${style.ball} `} title={tooltip}>
        {!onlyBall ? <ReactTooltip id={'ball-' + id}
                                   aria-haspopup='true'
                                   place={place}
                                   type={type}
                                   className={'custom-tooltip'}
                                   effect="solid">
            {tooltip}
        </ReactTooltip> : null}
        <div className={`${style.grouping_tag} ${className}`} data-tip data-for={'ball-' + id}>
            {text}
        </div>
    </div>;
});
