import React from 'react';

import { VOYAGE_PATH } from '../../components/Voyage/constants';
import { Link } from '../Link';
import style from './index.css';

export const IconBLE = React.memo(() => {
    return <span className={`${style.icon} ${style.ble}`}/>;
});

export const IconLongTerm = React.memo(() => {
    return <span className={`${style.icon} ${style.long_term}`}/>;
});

export const IconCorp = React.memo(() => {
    return <span className={`${style.icon} ${style.corp}`}/>;
});

export const IconYac = React.memo(() => {
    return <span className={`${style.icon} ${style.yac}`}/>;
});

export const IconTaxi = React.memo(() => {
    return <span className={`${style.icon} ${style.taxi}`}/>;
});

export const IconCountCircle = React.memo((props: { className?: string; count: number }) => {
    const { className, count } = props;

    return <span className={`${style.icon} ${style.circle} ${className ? className : ''}`}>{count}</span>;
});

export const IconVoyage = React.memo((props: { voyageId: string }) => {
    const href = `#${VOYAGE_PATH}${props.voyageId}`;

    return <Link href={href} target={'_blank'}>
        <span className={`${style.icon} ${style.voyage}`}/>
    </Link>;
});

export const DedicatedFleet = React.memo(() => {
    return <span className={style.dedicated_fleet}>ВП</span>;
});

export const MarketIcon = React.memo(() => {
    return <span className={`${style.icon} ${style.market}`}/>;
});
