import { storiesOf } from '@storybook/react';
import React, { useState } from 'react';

import { UIStatus, UIStatusTypes } from '../index';
import { Input } from './index';

const Wrapper = (props: {status?: UIStatus | null}) => {
    const [text, setText]: [string, (any) => void] = useState();

    return (
        <Input value={text} status={props.status} placeholder={'текст'} onChange={(e) => setText(e)}/>
    );
};

storiesOf('Input', module)
    .add('default', () => <Wrapper/>)
    .add('all statuses', () => <>
        <Wrapper status={null}/>
        <Wrapper status={{ type: UIStatusTypes.negative }}/>
        <Wrapper status={{ type: UIStatusTypes.warning }}/>
        <Wrapper status={{ type: UIStatusTypes.positive }}/>
        <Wrapper status={{ type: UIStatusTypes.info }}/>
    </>);
