import React from 'react';

import CheckIcon from '../../../svg-components/check.component.svg';
import style from './index.css';

interface IProps {
    checked: boolean | string;
    className?: string;
}

export const IsChecked = React.memo((props: IProps) => {
    return <CheckIcon className={`${style.component} ${props.checked == '1'
        ? style.active
        : ''} ${props.className || ''}`}/>;
});
