import React from 'react';

import { ytLogs } from '../../utils/sendLogs';
import { buttonLocationDetails, buttonNameDetails } from '../../utils/sendLogs/eventTypes/buttonDetails';
import { EVENT_TYPES } from '../../utils/sendLogs/eventTypes/eventTypes';
import style from './index.css';

interface ILinkProps {
    href?: string;
    title?: string;
    onClick?: () => void;
    className?: string;
    target?: string;
    disable?: boolean;
    ytLog?: {button_name: buttonNameDetails; location?: buttonLocationDetails; [x: string]: any};
    disablePreventDefault?: boolean;
}

export class Link extends React.Component<ILinkProps, any> {
    log: ytLogs | null = null;

    constructor(props: ILinkProps) {
        super(props);

        if (props.ytLog) {
            this.log = ytLogs.getInstance();
        }
    }

    onClick(e: KeyboardEvent) {
        if (this.props.ytLog && this.log) {
            this.log.send({
                data: {
                    event_type: EVENT_TYPES.CLICK_BUTTON,
                    ...this.props.ytLog,
                },
            });
        }

        if (!this.props.href || this.props.href && this.props.onClick && !this.props.disablePreventDefault) {
            e.preventDefault();
        }

        e.stopPropagation();
        this.props.onClick && this.props.onClick();
    }

    render() {
        const isInteractive = this.props.onClick;

        return <a href={this.props.href || '/'}
                  title={this.props.title}
                  rel={"noopener"}
                  target={this.props.target}
                  className={`${style.link}`
                  + ` ${isInteractive ? style['link_interactive'] : ''}`
                  + ` ${this.props.className || ''}`
                  + ` ${this.props.disable ? style.disable : ''}`
                  }
                  onClick={this.onClick.bind(this)}>{this.props.children}</a>;
    }
}
