import * as React from 'react';

import Img from '../../components/Img';
import { PictureGallery } from '../../components/PictureGallery';
import { Link } from '../Link';
import * as style from './index.css';

interface IPictureBlocksViewerProps {
    pictures: IPicture[];
}

interface IPictureBlocksViewerState {
    galleryInitialIndex: number | null;
    isPictureGalleryOpen: boolean;
}

export class PictureBlocksViewer extends React.Component<IPictureBlocksViewerProps, IPictureBlocksViewerState> {
    state: IPictureBlocksViewerState = {
        galleryInitialIndex: null,
        isPictureGalleryOpen: false,
    };

    openPictureGallery(galleryInitialIndex: number) {
        this.setState({ galleryInitialIndex, isPictureGalleryOpen: true });
    }

    closePictureGallery() {
        this.setState({ galleryInitialIndex: null, isPictureGalleryOpen: false });
    }

    render() {
        const { pictures } = this.props;
        const { galleryInitialIndex, isPictureGalleryOpen } = this.state;

        return <div className={`${style.picture_blocks_viewer}`}>
            {pictures.length
                ? pictures.map((picture, index) => {
                    return <PictureBlock picture={picture}
                                         key={`${picture.link}_${index}`}
                                         openPictureInfo={{
                                             openPictureHandler: this.openPictureGallery.bind(this),
                                             index,
                                         }}/>;
                })
                : <h4>Список изображений пустой</h4>}
            {isPictureGalleryOpen
                ? <PictureGallery initialIndex={galleryInitialIndex ?? 0}
                                  pictures={pictures}
                                  onClose={this.closePictureGallery.bind(this)}/>
                : null}
        </div>;
    }
}

export interface IPicture {
    link: string;
    info: any;
}

interface IPictureBlockProps {
    picture: IPicture;
    openPictureInfo?: { openPictureHandler: () => void; index: number };
}

interface IPictureBlockState {

}

export class PictureBlock extends React.Component<IPictureBlockProps, IPictureBlockState> {
    state: IPictureBlockState = {};

    render() {
        const { picture } = this.props;
        const { link, info } = picture;
        const openPictureInfo = this.props.openPictureInfo;
        const index = openPictureInfo?.index ?? null;
        const openPictureHandler: (() => void) | null = openPictureInfo?.openPictureHandler ?? null;

        return <div className={style.picture_block} key={link}>
            <div className={style.picture_container}>
                {openPictureHandler
                    ? <Link onClick={openPictureHandler.bind(null, index)}>
                        <Img src={link}/>
                    </Link>
                    : <Img src={link}/>}
            </div>
            <div className={style.picture_info}>
                {info ?? null}
            </div>
        </div>;
    }
}
