import * as React from 'react';

import { IDrivingStyleItem } from '../../components/Clients/UserCardSidebar/UserDrivingStyle/types';
import styles from './index.css';

interface IProfileProgressBarProps {
    size: 'xs' | 's' | 'm' | 'l';
    currentDrivingStyleItem: IDrivingStyleItem;
    onClick?: () => void;
}

const sizeList = {
    's': 120,
    'm': 200,
    'l': 290,
};

const radiusList = {
    's': 10,
    'm': 16,
    'l': 20,
};

const MIN_WIDTH = 2;
const MID_WIDTH = 12;
const COEFFICIENT = 3.5;
const TRIAL_STAGE = 'trial_stage';

export const ProfileProgressBar = (props: IProfileProgressBarProps) => {
    const { size, onClick, currentDrivingStyleItem } = props;
    const { next_color, prev_color, prev_value, next_value, id, parts, value } = currentDrivingStyleItem;

    const filledParts = +(currentDrivingStyleItem?.caption?.match(/\d+/)?.[0] || '');
    const isBlocked = !prev_value && !next_value && !value;
    const diff = next_value - prev_value;
    const height = sizeList[size] / COEFFICIENT;
    let width = value ? (((value - prev_value) / diff) * sizeList[size] || MIN_WIDTH) : 0;

    if (value !== undefined && width < MIN_WIDTH) {
        width = MIN_WIDTH;
    } else if (isBlocked) {
        width = sizeList[size];
    }

    return <div onClick={onClick}
                className={`${styles.progressBar} ${styles[`size_${size}`]}`}
                style={{
                    '--size': `${sizeList[size]}px`,
                    '--width': `${width}px`,
                    '--calcHeight': `${height - height / width}px`,
                    '--background': `linear-gradient(to right, ${prev_color}, ${next_color})`,
                    '--radius': `${radiusList[size]}px`,
                    '--rightRadius': `${radiusList[size] - (sizeList[size] - width)}px`,
                    '--perspective': `${width < MID_WIDTH ? radiusList[size] : radiusList[size] * MIN_WIDTH}px`,
                    '--parts': parts,
                } as React.CSSProperties}>
        {parts
            ? <>
                <div className={styles['rect-banned']}>
                    {new Array(parts).fill('').map((part, index) => {
                        return <div key={`part${index}`}
                                    className={`${styles.part} ${index < filledParts ? styles.filled : styles.empty}`}/>;
                    })}
                </div>
            </>
            : <>
                <div className={styles.rect}/>
                {width < radiusList[size]
                    ? <div className={styles.coloredRect}/>
                    : <div className={`${styles.rect} ${width < sizeList[size] - radiusList[size] ? '' : styles.round}`}/>}
            </>}

        <div className={styles.limits}>
            <div className={styles.limit}>
                {prev_value}
                {id === TRIAL_STAGE && <p>км</p>}
            </div>
            <div className={styles.value}>
                {value !== undefined && !parts ? value : ''}
                {id === TRIAL_STAGE && <p>км</p>}
            </div>
            <div className={styles.limit}>
                {next_value}
                {id === TRIAL_STAGE && <p>км</p>}
            </div>
        </div>
    </div>;
};
