import * as React from 'react';

import { Button } from '../Button';
import { Window } from '../FullModal';
import style from './index.css';

interface IProposeExistWarningModalProps {
    onClose: () => void;
}

export default class ProposeExistWarningModal extends React.Component<IProposeExistWarningModalProps, any> {
    render() {
        const { onClose } = this.props;

        return <Window onClose={onClose.bind(this)}
                       title={'Предупреждение'}>
            <div className={style.warn_modal}>
                <h3>Предложение с таким именем уже существует!</h3>
                <div>Для начала подтвердите или отклоните существующее предложение, или поменяйте название</div>
                <Button onClick={onClose.bind(this)}
                        className={style.ok_button}>OK</Button>
            </div>
        </Window>;
    }
}
