import * as React from 'react';

import { ButtonTypes } from '../../Button';
import { Radio } from '../component';

export interface IRadioGroupOptions {
    label: string;
    value: string;
    isDefault?: boolean;
}

interface IRadioGroupProps {
    options: IRadioGroupOptions[];
    id: string;
    onSelect: (value: string) => void;
    initialSelectedValue?: string | null;
    className?: string;
    colorType?: ButtonTypes;
}

export const RadioGroup = (props: IRadioGroupProps) => {
    const { options, id, onSelect, className, initialSelectedValue, colorType } = props;
    const [selectedValue, setSelectedValue] = React.useState<string | null>(initialSelectedValue ?? null);

    React.useEffect(() => {
        if (!initialSelectedValue) {
            options.forEach((option) => {
                if (option.isDefault) {
                    setSelectedValue(option.value);
                }
            });
        }
    }, []);

    return <div className={className ?? ''}>
        {options.map((option, index) => {
            return <Radio colorType={colorType}
                          key={index}
                          selectedValue={selectedValue}
                          onSelect={(value) => {
                              setSelectedValue(value);
                              onSelect(value);
                          }}
                          value={option.value}
                          id={`${id}-${index}`}
                          groupId={id}>
                {option.label}
            </Radio>;
        })}
    </div>;
};
