import * as React from 'react';

import RadioBorderIcon from '../../../svg-components/radio-border.component.svg';
import RadioCheckedIcon from '../../../svg-components/radio-checked.component.svg';
import { ButtonTypes } from '../Button';
import styles from './index.css';

interface IRadioProps {
    onSelect: (value: string) => void;
    value: string;
    id: string;
    groupId: string;
    colorType?: ButtonTypes;
    selectedValue: string | null;
}

export const Radio = (props: React.PropsWithChildren<IRadioProps>) => {
    const { onSelect, value, id, children, selectedValue, groupId, colorType } = props;

    return <span className={colorType ? styles[`radioColor_${colorType}`] : styles.radioColor_primary}>
        <input className={styles.radio}
               type="radio"
               checked={selectedValue === value}
               value={value}
               id={id}
               name={groupId}
               onChange={(event) => {
                   onSelect(event.target.value);
               }}/>
        <label htmlFor={id}
               className={styles.radioLabel}>
            <RadioBorderIcon className={styles.radioBorder}/>
            <RadioCheckedIcon className={styles.radioChecked}/>
            <span>{children}</span>
        </label>
    </span>;
};
