import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { ButtonTypes } from '../Button';
import Radio from './index';

storiesOf('Radio button', module)
    .add('initial - all colorTypes', () => {
        return <>
            <Radio onSelect={() => undefined}
                   value={'test'}
                   id={'1'}
                   selectedValue={'test'}
                   groupId={'1'}>
                Test
            </Radio>
            <Radio selectedValue={'test'}
                   onSelect={() => undefined}
                   value={'test 2'}
                   id={'2'}
                   groupId={'1'}>
                Test 2
            </Radio>
            <Radio selectedValue={'test 2'}
                   colorType={ButtonTypes.positive}
                   onSelect={() => undefined}
                   value={'test 2'}
                   id={'3'}
                   groupId={'2'}>
                Test 2
            </Radio>
            <Radio selectedValue={'test 3'}
                   colorType={ButtonTypes.negative}
                   onSelect={() => undefined}
                   value={'test 3'}
                   id={'4'}
                   groupId={'3'}>
                Test 2
            </Radio>
            <Radio selectedValue={'test 3'}
                   colorType={ButtonTypes.warning}
                   onSelect={() => undefined}
                   value={'test 3'}
                   id={'5'}
                   groupId={'4'}>
                Test 2
            </Radio>
        </>;
    });
