import React, { useState } from 'react';

import { CancelButton, SaveButton } from '../Button';
import { Window } from '../FullModal';
import * as coreStyle from '../index.css';
import { Input } from '../Input';

interface UrlEditModalProps {
    startValue: string;
    onSaveValue: (value: string) => void;
    closeModal: () => void;
}

export const UrlEditModal = function (props: UrlEditModalProps) {
    const [value, changeValue] = useState(props.startValue);
    const [url, changeUrl] = useState('');

    function saveLink() {
        const finalUrl = `[url=${encodeURI(url)}]${value}[/url]` ?? '';
        props.onSaveValue(finalUrl);
        props.closeModal();
    }

    return <Window onClose={props.closeModal.bind(null, '')}>
        <Input value={value} onChange={changeValue} placeholder={'Текст'}/>
        <Input value={url} onChange={changeUrl} placeholder={'Ссылка'}/>

        <div className={coreStyle.button_container}>
            <CancelButton onClick={props.closeModal.bind(null, '')}/>
            <SaveButton onClick={saveLink}/>
        </div>
    </Window>;
};
