import React from 'react';

import * as style from './index.css';

interface ISeparatorLineProps {
    title?: string | null;
}

export const SeparatorLine = React.memo((props: ISeparatorLineProps) => {
    const { title } = props;

    return <div className={style.separator}>
        {title ? <div className={style.separator_title}>{title}</div> : null}
        <div className={style.separator_line}/>
    </div>;
});
