import React from 'react';

import * as style from './index.css';

export enum StatusTypes {
    DEFAULT = 'default',
    INFO = 'info',
    WARNING_LIGHT = 'warning_light',
    WARNING_DARK = 'warning_dark',
    POSITIVE = 'positive',
    NEGATIVE = 'negative',
    PURPLE = 'purple',
}

interface IStatusProps {
    text: string;
    status?: StatusTypes;
}

export const Status = React.memo((props: IStatusProps) => {
    const statusType = props.status || StatusTypes.DEFAULT;

    return <div className={style.user_status_container}>
        <div className={`${style.user_status} ${style[statusType]}`}>
            <div className={`${style.status_icon} ${style[statusType]}`}/>
            <span className={`${style.status_title} ${style[statusType]}`}>{props.text}</span>
        </div>
    </div>;
});

export enum CarStatuses {
    AVALIABLE = 'available',
    RESERVATION = 'reservation',
    RIDE = 'ride',
    OLD_STATE_RIDING = 'old_state_riding',
    PARKING = 'parking',
    SERVICE = 'service',
}

export const CarStatus = React.memo((props: IStatusProps) => {
    let statusType = props.status || StatusTypes.DEFAULT;

    if (!props.status) {
        switch (props.text) {
        case CarStatuses.AVALIABLE:
            statusType = StatusTypes.POSITIVE;
            break;
        case CarStatuses.RESERVATION:
            statusType = StatusTypes.PURPLE;
            break;
        case CarStatuses.RIDE:
            statusType = StatusTypes.INFO;
            break;
        case CarStatuses.OLD_STATE_RIDING:
            statusType = StatusTypes.INFO;
            break;
        case CarStatuses.PARKING:
            statusType = StatusTypes.WARNING_LIGHT;
            break;
        case CarStatuses.SERVICE:
            statusType = StatusTypes.WARNING_DARK;
            break;
        }
    }

    return <Status text={props.text} status={statusType}/>;
});

export enum UserStatuses {
    ACTIVE = 'active',
    ON_BOARDING = 'onboarding',
    BAD_AGE = 'bad_age',
    BAD_DRIVING_EXP = 'bad_driving_exp',
    REG_FRAUD = 'reg_fraud',
    DEBT = 'debt',
    REJECTED = 'rejected',
    BLOCKED = 'blocked',
    SCREENING = 'screening',
    FAST_REG = 'fastregistered',
}

export const UserStatus = React.memo((props: IStatusProps) => {
    let statusType = props.status || StatusTypes.DEFAULT;

    if (!props.status) {
        switch (props.text) {
        case UserStatuses.ACTIVE:
            statusType = StatusTypes.POSITIVE;
            break;
        case UserStatuses.ON_BOARDING:
            statusType = StatusTypes.INFO;
            break;
        case UserStatuses.DEBT:
            statusType = StatusTypes.WARNING_LIGHT;
            break;
        case UserStatuses.SCREENING:
            statusType = StatusTypes.WARNING_DARK;
            break;
        case UserStatuses.REJECTED:
        case UserStatuses.BLOCKED:
        case UserStatuses.BAD_AGE:
        case UserStatuses.BAD_DRIVING_EXP:
            statusType = StatusTypes.NEGATIVE;
            break;
        default:
            statusType = StatusTypes.DEFAULT;
            break;
        }
    }

    return <Status text={props.text} status={statusType}/>;
});
