import * as React from 'react';

import * as style from './index.css';

export interface ISwitcherItem {
    text: string;
    value: string | number;
    disabled?: boolean;
}

interface IProps {
    items: ISwitcherItem[];
    active: string | number;
    onChange?: () => void;
    textAlign?: 'left' | 'right' | 'center';
    horizontal?: boolean;
}

export const Switcher = (props: IProps) => {
    return <div className={`${style.switcher} ${props.horizontal ? style.horizontal : ''}`}>
        {
            props.items.map((item: any, index: number) =>
                <div key={index}
                     onClick={props.onChange && !item.disabled && props.onChange.bind(null, item.value) || null}
                     className={
                         `${style.switcher_item} ` +
                         `${props.active === item.value ? style.active : ''} ` +
                         `${item.disabled ? style.disabled : ''}`
                     }
                     style={{ textAlign: props.textAlign }}>
                    {item.text}
                </div>)
        }
    </div>;
};
