import * as React from 'react';

import * as style from './index.css';

export enum LabelStatus {
    POSITIVE = 'positive',
    NEGATIVE = 'negative',
    WARNING = 'warning',
    WARNING_DARK = 'warning_dark',
    NEGATIVE_DARK = 'negative_dark',
    INFO = 'info',
    DEFAULT = 'default',
}

interface ITLabel {
    status: LabelStatus;
    text?: string;
    className?: string;
    style?: React.CSSProperties;
}

export const TLabel = React.memo((props: ITLabel) => {
    const status = props.status && props.status.toUpperCase()
        && LabelStatus[props.status.toUpperCase()]
        || LabelStatus.DEFAULT;
    const _style = (props?.style || {}) as React.CSSProperties;

    return <div style={_style}
                className={`${style.label} ${style['label-' + status]} `
        + `${props.className || ''}`}>{props.text || status}</div>;
});
