import React from 'react';

import { LOCALIZATION_RESOURCE_PREFIX } from '../../constants';
import { Translate } from '../../utils/translate';
import { Collapse2 } from '../Collapse2';
import { WARNING_LABEL } from '../Select';
import * as style from './index.css';

export type TabItem<T = string> = {
    name: string;
    link: T;
    order?: number;
    active?: boolean;
    required?: boolean;
}

interface TabsProps {
    tabs: TabItem[];
    currentTab: string;
    className?: string;
    selectTab: (item?: string) => void;
    t?: Translate;
    collapsed?: boolean;
    collapsedTitle?: string;
}

const Tabs = React.memo((props: TabsProps) => {
    const { currentTab, tabs, selectTab, className = '', t, collapsed, collapsedTitle = '' } = props;

    const tabsContainer = tabs?.sort?.((item1, item2) => (item1.order || 0) - (item2.order || 0))
        ?.map?.((item, index) => {
            const displayValue = t && t.getItem(LOCALIZATION_RESOURCE_PREFIX + item.name) || item.name;

            return <div className={`${style.tab_item} ${(item.link === currentTab ? style.active : '')}`}
                        key={index}
                        onFocus={selectTab.bind(null, item.link)}
                        onClick={selectTab.bind(null, item.link)}>
                {displayValue ? '' : `${WARNING_LABEL} Empty tab value`} {displayValue}
            </div>;
        });

    return (
        <div className={`${style.tabs} ${className}`}>
            {
                collapsed ? <Collapse2 title={collapsedTitle} expendByRoot>{tabsContainer}</Collapse2> : tabsContainer
            }
        </div>
    );
});
export { Tabs };
