import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import React from 'react';

import TextArea from './index';

require('../../components/App/index.css');

const PLACEHOLDER = 'Введите текст';
const _JSON = { 'key': 'key', 'passed_in': ['hey', 'react'] };
storiesOf('TextArea', module)
    .add('default', () => (
        <TextArea value={'Hello word'} onChange={action('changed')} placeholder={PLACEHOLDER}/>
    ))
    .add('with incorrect json', () => (
        <TextArea value={'Hello word'} onChange={action('changed')} placeholder={PLACEHOLDER} json={true}/>
    ))
    .add('with correct json', () => (
        <TextArea value={JSON.stringify(_JSON)}
                  onChange={action('changed')}
                  placeholder={PLACEHOLDER}
                  json={true}/>
    ))
    .add('disabled', () => (
        <TextArea value={'Hello word'} disabled={true} onChange={action('changed')} placeholder={PLACEHOLDER}/>
    ));
