import React from 'react';

import MastercardIcon from '../../../../svg-components/mastercard.component.svg';
import VisaIcon from '../../../../svg-components/visa.component.svg';
import { PaymentSystem } from '../../../components/Settings/Wallets/types';
import { IconYac } from '../../Icons';
import * as style from './index.css';

interface IPaymentSystemLogosProps extends IPaymentSystemLogoProps{
    value: PaymentSystem | string;
}

interface IPaymentSystemLogoProps {
    className?: string;
}

export const PaymentSystemLogos = React.memo((props: IPaymentSystemLogosProps) => {
    return (
        <>
            {props.value.toLowerCase() === PaymentSystem.MASTERCARD
                ? <MasterCard className={props.className}/>
                : props.value.toLowerCase() === PaymentSystem.VISA
                    ? <Visa className={props.className}/>
                    : props.value.toLowerCase() === PaymentSystem.YANDEX_ACCOUNT
                        ? <YandexAccount className={props.className}/>
                        : <span className={props.className ? props.className : ''}>
                            {props.value}
                        </span>
            }
        </>
    );
});

const Visa = React.memo((props: IPaymentSystemLogoProps) => {
    return <VisaIcon title={PaymentSystem.VISA}
                     className={`${style.logo} ${style.visa} ${props.className}`}/>;
});

const MasterCard = React.memo((props: IPaymentSystemLogoProps) => {
    return <MastercardIcon title={PaymentSystem.MASTERCARD}
                           className={`${style.logo} ${style.mastercard} ${props.className}`}/>;
});

const YandexAccount = React.memo((props: IPaymentSystemLogoProps) => {
    return <span title={PaymentSystem.YANDEX_ACCOUNT}
                 className={`${style.logo} ${style.yandex_account} ${props.className}`}>
        <IconYac/>
    </span>;
});
