import { storiesOf } from '@storybook/react';
import React from 'react';

import {
    AccountDataType,
    AccountType,
    IAccount,
    ITrustCard,
    IYandexAccount,
    PaymentSystem,
} from '../../components/Settings/Wallets/types';
import { Wallet } from './index';

require('../../components/App/index.css');

storiesOf('Wallet', module)
    .add('Account, type: card', () => {
        const account: IAccount = {
            name: 'За свои',
            type: AccountType.CARD,
            id: 1234,
            balance: 9999,
            spent: 10000,
            details: {
                card_mask: '553691****4313',
            },
            soft_limit: 99999999,
            hard_limit: 1000000,
            is_active: true,
            data_type: AccountDataType.CARD,
            type_name: 'card',
            comment: '',
            is_actual: true,
        };

        return (
            <Wallet account={account}
                    onEdit={() => undefined}
                    onDelete={() => undefined}
                    setActive={() => undefined}
                    active={account.is_active}/>
        );
    })
    .add('Account, type: wallet', () => {
        const account: IAccount = {
            name: 'Драйв',
            type: AccountType.WALLET,
            id: 1234,
            balance: 9999,
            spent: 10000,
            details: {
                expenditure: 242457,
                next_refresh: 1572566400,
            },
            soft_limit: 99999999,
            hard_limit: 1000000,
            is_active: true,
            data_type: AccountDataType.SALARY,
            type_name: 'ya.drive',
            comment: '',
            is_actual: true,
        };

        return (
            <Wallet account={account}
                    onEdit={() => undefined}
                    onDelete={() => undefined}
                    setActive={() => undefined}
                    active={account.is_active}/>
        );
    })
    .add('Account, type: bonus', () => {
        const account: IAccount = {
            name: 'Бонусы',
            type: AccountType.BONUS,
            id: 1234,
            balance: 9999,
            spent: 10000,
            details: {
                balance: 0,
            },
            soft_limit: 99999999,
            hard_limit: 1000000,
            is_active: true,
            data_type: AccountDataType.BONUS,
            type_name: 'bonus',
            comment: '',
            is_actual: true,
        };

        return (
            <Wallet account={account}
                    onEdit={() => undefined}
                    onDelete={() => undefined}
                    setActive={() => undefined}
                    active={account.is_active}/>
        );
    })
    .add('Account, type: bonus, state: blocked', () => {
        const account: IAccount = {
            name: 'Бонусы',
            type: AccountType.BONUS,
            id: 1234,
            balance: 9999,
            spent: 10000,
            details: {
                balance: 0,
            },
            soft_limit: 99999999,
            hard_limit: 1000000,
            is_active: false,
            data_type: AccountDataType.BONUS,
            type_name: 'bonus',
            comment: '',
            is_actual: true,
        };

        return (
            <Wallet account={account}
                    onEdit={() => undefined}
                    onDelete={() => undefined}
                    setActive={() => undefined}
                    active={account.is_active}/>
        );
    })
    .add('Trust card', () => {
        const card: ITrustCard = {
            payment_method: 'card',
            account: '123456****7890',
            id: 'card-abcdefghijklmnopqrstuvwxy',
            aliases: ['card-abcdefghijklmnopqrstuvwxy'],
            binding_ts: 1570570416,
        };

        return (
            <Wallet card={card}
                    active/>
        );
    })
    .add('Expired card', () => {
        const card: ITrustCard = {
            payment_method: 'card',
            account: '123456****7890',
            id: 'card-abcdefghijklmnopqrstuvwxy',
            aliases: ['card-abcdefghijklmnopqrstuvwxy'],
            binding_ts: 1570570416,
            expired: true,
        };

        return (
            <Wallet card={card}
                    active/>
        );
    })
    .add('YandexAccount - with & without binding_ts', () => {
        const yandexAccount: IYandexAccount = {
            account: 'w/c407f2ce-d066-5d1e-9fcf-799de655cbe6',
            aliases: [],
            balance: 0,
            binding_ts: 0,
            card_bank: '',
            card_level: '',
            id: 'yandex_account-w/c407f2ce-d066-5d1e-9fcf-799de655cbe6',
            payment_method: 'yandex_account',
            system: '',
        };

        const yandexAccountBindingTs: IYandexAccount = {
            account: 'w/c407f2ce-d066-5d1e-9fcf-799de655cbe6',
            aliases: [],
            balance: 0,
            binding_ts: 12345,
            card_bank: '',
            card_level: '',
            id: 'yandex_account-w/c407f2ce-d066-5d1e-9fcf-799de655cbe6',
            payment_method: 'yandex_account',
            system: '',
        };

        return <div style={{ display: 'flex', flexWrap: 'wrap' }}>
            <Wallet yandexAccount={yandexAccount}
                    active/>
            <Wallet yandexAccount={yandexAccountBindingTs}
                    active/>
        </div>;
    })
    .add('Trust card - MasterCard & Visa', () => {
        const card_mastercard_black: ITrustCard = {
            payment_method: 'card',
            account: '123456****7890',
            id: 'card-abcdefghijklmnopqrstuvwxy',
            aliases: ['card-abcdefghijklmnopqrstuvwxy'],
            binding_ts: 1570570416,
            card_bank: 'AO ',
            card_level: 'WORLD ELITE',
            system: PaymentSystem.MASTERCARD,
        };

        const card_visa_infinite: ITrustCard = {
            payment_method: 'card',
            account: '123456****7890',
            id: 'card-abcdefghijklmnopqrstuvwxy',
            aliases: ['card-abcdefghijklmnopqrstuvwxy'],
            binding_ts: 1570570416,
            card_bank: 'AO ',
            card_level: 'INFINITE',
            system: PaymentSystem.VISA,
        };

        const card_visa_platinum: ITrustCard = {
            payment_method: 'card',
            account: '123456****7890',
            id: 'card-abcdefghijklmnopqrstuvwxyuuuuuuuuuuu',
            aliases: ['card-abcdefghijklmnopqrstuvwxy'],
            binding_ts: 1570570416,
            card_bank: 'TINKOFF BANK',
            card_level: 'PLATINUM SALARY',
            system: PaymentSystem.VISA,
        };

        const card_mastercard_world: ITrustCard = {
            payment_method: 'card',
            account: '123456****7890',
            id: 'card-abcdefghijklmnopqrstuvwxy',
            aliases: ['card-abcdefghijklmnopqrstuvwxy'],
            binding_ts: 1570570416,
            card_bank: 'TINKOFF BANK',
            card_level: 'WORLD',
            system: PaymentSystem.MASTERCARD,
        };

        const card_mastercard_gold: ITrustCard = {
            payment_method: 'card',
            account: '123456****7890',
            id: 'card-abcdefghijklmnopqrstuvwxy',
            aliases: ['card-abcdefghijklmnopqrstuvwxy'],
            binding_ts: 1570570416,
            card_bank: 'TINKOFF BANK',
            card_level: 'GOLD',
            system: PaymentSystem.MASTERCARD,
        };

        const card_visa: ITrustCard = {
            payment_method: 'card',
            account: '123456****7890',
            id: 'card-abcdefghijklmnopqrstuvwxy',
            aliases: ['card-abcdefghijklmnopqrstuvwxy'],
            binding_ts: 1570570416,
            card_bank: 'TINKOFF BANK',
            card_level: 'STANDARD',
            system: PaymentSystem.VISA,
        };

        const card_visa_expired: ITrustCard = Object.assign({}, card_visa, { expired: true });

        return (
            <div style={{ display: 'flex', flexWrap: 'wrap' }}>
                <Wallet card={card_mastercard_black}
                        active/>
                <Wallet card={card_mastercard_world}
                        active/>
                <Wallet card={card_mastercard_gold}
                        active/>
                <Wallet card={card_visa_infinite}
                        active/>
                <Wallet card={card_visa_platinum}
                        active/>
                <Wallet card={card_visa}
                        active/><Wallet card={card_visa_expired}
                                        active/>
            </div>
        );
    })
    .add('B2B account with parent structure', () => {
        const account_b2b = {
            'name': 'Яндекс',
            'details': {
                'soft_limit': 0,
                'comment': '',
                'company': '',
                'hard_limit': 0,
                'expenditure': 0,
                'next_refresh': 1604620800,
            },
            'balance': 100000000000,
            'parent': {
                'id': 3447637,
                'is_active': true,
                'type_id': 114,
                'balance': 837234983,
            },
            'spent': 0,
            'offers_filter': 'corporate*corporate_ydx',
            'soft_limit': 100000000,
            'comment': '',
            'data_type': AccountDataType.SIMPLE,
            'id': 3449175,
            'is_actual': true,
            'type_name': 'drivecovid19',
            'disabled': false,
            'type': AccountType.WALLET,
            'is_active': true,
            'offers_filter_name': '',
            'hard_limit': 1000000000,
            'version': 238,
            'selectable': true,
        };

        return <Wallet account={account_b2b}
                       active={true}/>;
    })
;
