/*eslint-disable*/
import React, { FormEvent, useState } from 'react';
import { storiesOf } from '@storybook/react';
import { Input } from './Input';
import { action } from '@storybook/addon-actions';
import TextArea from './TextArea';
import Checkbox from './Checkbox';
import { Button } from './Button';
import DatePicker from './DatePicker';
import Select, { IOptionInfo } from './Select';

import style from './index.story.css';

const handleSubmit = (event: FormEvent) => {
    event.preventDefault();
};

const MOCK_SELECT_OPTIONS: IOptionInfo[] = [
    {text: 'Один', value: 1},
    {text: 'Два', value: 2},
    {text: 'Три', value: 3},
    {text: 'Четыре', value: 4},
    {text: 'Пять', value: 5}
];

const Wrapper = () => {
    const [rule, setRule] = useState('Название правила');
    const [route, setRoute] = useState('Блок UI / роут');
    const [date, setDate] = useState(new Date());
    return (
        <form onSubmit={handleSubmit} className={style.form}>
            <Input value={rule} placeholder={'Cписок ролей'} onChange={(e) => setRule(e)}/>
            <DatePicker value={date} placeholder={'Введите дату'} onChange={(e) => setDate(e)}/>
            <Input value={route} placeholder={'Cписок ролей'} onChange={(e) => setRoute(e)}/>
            <TextArea value={'Список ролей'} placeholder={'Cписок ролей'} onChange={action('changed')}/>
            <Select multiSelect={true} initialValues={[1, 2, 3, 4, 6]} options={MOCK_SELECT_OPTIONS}
                    placeholder={'Выберите'} onSelect={() => {
            }}/>
            <div className={style.form__controls}>
                <Checkbox checked={true}/>
                <Button onClick={action('clicked')}>Отправить</Button>
            </div>
        </form>
    );
};

storiesOf('All', module)
    .add('default', () => <Wrapper/>);
