export enum UIStatusTypes {
    positive = 'positive',
    negative = 'negative',
    info = 'info',
    warning = 'warning',
}

export interface UIStatus {
    type: UIStatusTypes;
    text?: string;
}

export interface UIComponent {
    className?: string;
    placeholder?: string | JSX.Element;
    disabled?: boolean;
    status?: UIStatus | null;
    required?: boolean;
    description?: string;
}

export interface UITextComponent extends UIComponent {
    value: any;
    onChange: (value: any) => any;
}
